<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * DaaS CodeIgniter Form validation Extension
 *
 * @package        	CodeIgniter
 * @subpackage    	Libraries
 * @category    	Libraries
 * @author        	         , Shawn        s
 *
 */
 
class DPII_Form_validation extends CI_Form_validation {

    public function __construct()
    {
        parent::__construct();
    }
	
	/*
	 * phone validation checks that the passed value is a valid phone number
	*/
	public function validate_phone($phone){
		//if the phone number is null or not set return true
		if (!isset($phone) || $phone === ''){
			return true;
		}
		//check if the phone number follows standard format
		if (preg_match('/^(?:\((\+?\d+)?\)|\+?\d+) ?\d*(-?\d{2,3} ?){0,4}$/', $phone)){
			return true;
		}else{
			$CI =& get_instance();
			$CI->load->library('form_validation');
			$CI->form_validation->set_message('validate_phone', 'The %s field must be a valid phone number.');
			return false;
		}
	}
	
	/*
	 * checks if the user name entered on create user page already exists in the database 
	*/
	public function unique_username($user_name) {
		$CI =& get_instance();
		$this->CI->load->model('usersmodel');
		$user_name = strtolower($user_name);
		if(!$this->CI->usersmodel->username_exists($user_name)) {
			return true;
		}
		else {
			$CI->load->library('form_validation');
			$CI->form_validation->set_message('unique_username', 'The user name already exists in the system.');
			return false;
		}
	}
}